package parser;

/**
 * Grammar non-terminal -- E ::= T E1
 */
public class E {
    /**
     * T object.
     */
    private T _t;

    /**
     * E1 object.
     */
    private E1 _e1;

    /**
     * Constructor for the E grammar non-terminal.
     *
     * @param t  T object
     * @param e1 E1 object
     */
    public E(T t, E1 e1) {
        _t = t;
        _e1 = e1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _t.toString() + _e1.toString();
    }
}

